//  Copyright 2019 mobileknowledge. All rights reserved.
//

#import <UIKit/UIKit.h>
#import "PWMUseCase.h"
#import "Utils.h"
#import "NTAG5_NFC_LIB.h"
#import "Config.h"

NS_ASSUME_NONNULL_BEGIN

@interface PwmUseCasePage : UIViewController

/* UI VIEWS */
@property (strong, nonatomic) IBOutlet          UIView *mainView;
@property (weak, nonatomic)   IBOutlet          UIView *channel0View;
@property (weak, nonatomic)   IBOutlet          UIView *channel1View;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarConfigCh0DropDown;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh0DropDown;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh1DropDown;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarConfigCh1DropDown;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh0DropdownList;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh0bbitOption;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh08bitOption;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh010bitOption;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh012bitOption;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh0DropDownList;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh000bOption;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh001bOption;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh010Option;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh011Option;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh1DropdownList;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh1bbitOption;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh18bitOption;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh110bitOption;
@property (weak, nonatomic)   IBOutlet          UIView *resolutionCh112bitOption;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh1DropDownList;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh100bOption;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh101bOption;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh110Option;
@property (weak, nonatomic)   IBOutlet          UIView *prescalarCh111Option;
@property (weak, nonatomic)   IBOutlet          UIView *configDropDownList;

/* UI SCROLLVIEWS */
@property (weak, nonatomic)   IBOutlet          UIScrollView *scrollView;

/* UI SLIDERS */
@property (weak, nonatomic)   IBOutlet          UISlider *startTimeCh0Slider;
@property (weak, nonatomic)   IBOutlet          UISlider *dutyCycleCh0Slider;
@property (weak, nonatomic)   IBOutlet          UISlider *startTimeCh1Slider;
@property (weak, nonatomic)   IBOutlet          UISlider *dutyCycleCh1Slider;

/* UI LABELS */
@property (weak, nonatomic)   IBOutlet          UILabel *resolutionCh0DropDownTitle;
@property (weak, nonatomic)   IBOutlet          UILabel *prescalarConfigCh0DropDownTitle;
@property (weak, nonatomic)   IBOutlet          UILabel *startTimeCh0Label;
@property (weak, nonatomic)   IBOutlet          UILabel *dutyCycleCh0Label;
@property (weak, nonatomic)   IBOutlet          UILabel *frequencyCh0Label;
@property (weak, nonatomic)   IBOutlet          UILabel *resolutionCh1DropDownTitle;
@property (weak, nonatomic)   IBOutlet          UILabel *prescalarConfigCh1DropDownTitle;
@property (weak, nonatomic)   IBOutlet          UILabel *startTimeCh1Label;
@property (weak, nonatomic)   IBOutlet          UILabel *dutyCycleCh1Label;
@property (weak, nonatomic)   IBOutlet          UILabel *frequencyCh1Label;
@property (weak, nonatomic)   IBOutlet          UILabel *prescalarCh000Label;
@property (weak, nonatomic)   IBOutlet          UILabel *prescalarCh001Label;
@property (weak, nonatomic)   IBOutlet          UILabel *prescalarCh010Label;
@property (weak, nonatomic)   IBOutlet          UILabel *prescalarCh011Label;

/* UI TEXTVIEW */
@property (weak, nonatomic)   IBOutlet          UITextView *LogText;

/* UI BUTTONS */
@property (weak, nonatomic)   IBOutlet          UIButton *writeConfigButton;
@property (weak, nonatomic)   IBOutlet          UIButton *readConfigButton;

/* GESTURE & TAP RECOGNIZERS */
- (IBAction)resolutionCh0DropDownListTap:       (UIGestureRecognizer*)sender;
- (IBAction)resolutionCh06bitOptionSelected:    (UIGestureRecognizer *)sender;
- (IBAction)resolutionCh08bitOptionSelected:    (UIGestureRecognizer *)sender;
- (IBAction)resolutionCh010bitOptionSelected:   (UIGestureRecognizer *)sender;
- (IBAction)resolutionCh012bitOptionSelected:   (UIGestureRecognizer *)sender;
- (IBAction)prescaleCh000bitOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)prescaleCh001bitOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)prescaleCh010bitOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)prescaleCh011bitOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)prescalarCh0DropDownListTap:        (UIGestureRecognizer *)sender;

- (IBAction)resolutionCh1DropDownListTap:       (UIGestureRecognizer*)sender;
- (IBAction)resolutionCh16bitOptionSelected:    (UIGestureRecognizer *)sender;
- (IBAction)resolutionCh18bitOptionSelected:    (UIGestureRecognizer *)sender;
- (IBAction)resolutionCh110bitOptionSelected:   (UIGestureRecognizer *)sender;
- (IBAction)resolutionCh112bitOptionSelected:   (UIGestureRecognizer *)sender;

- (IBAction)prescaleCh100bitOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)prescaleCh101bitOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)prescaleCh110bitOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)prescaleCh111bitOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)prescalarCh1DropDownListTap:        (UIGestureRecognizer *)sender;

- (IBAction)navBarButtonClick:                  (id)sender;
- (IBAction)setI2cSlaveModeOptionSelected:      (UIGestureRecognizer *)sender;
- (IBAction)setI2cMasterModeOptionSelected:     (UIGestureRecognizer *)sender;
- (IBAction)setGPIOPWMModeOptionSelected:       (UIGestureRecognizer *)sender;
- (IBAction)getUseCaseCongifOptionSelected:     (UIGestureRecognizer *)sender;

- (IBAction)writeConfigButtonClick:             (UIButton *)sender;
- (IBAction)readConfigButtonClick:              (UIButton *)sender;

/*!
 *@abstract   Writes the logs into the PWM View Controller
 **/
- (void) writeLog:                              (NSString *) cmd
         response:                              (NSData *) resp;

@end

NS_ASSUME_NONNULL_END
